/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import oracle.sql.converter.CharacterConverter12Byte;

public class CharacterConverterShift
extends CharacterConverter12Byte {
    public final byte SHIFT_OUT = (byte)14;
    public final byte SHIFT_IN = (byte)15;

    public CharacterConverterShift() {
        this.m_groupId = 7;
    }

    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        int n3 = 15;
        int n4 = 0;
        while (n4 < n) {
            char c = this.toOracleCharacter(cArray[n4]);
            int n5 = c & 0xFF00;
            if (n5 != 0) {
                if (n3 == 15) {
                    n3 = 14;
                    byArray[n2++] = 14;
                }
                byArray[n2++] = (byte)(n5 >> 8);
                byArray[n2++] = (byte)c;
            } else {
                if (n3 == 14) {
                    n3 = 15;
                    byArray[n2++] = 15;
                }
                byArray[n2++] = (byte)c;
            }
            ++n4;
        }
        if (n2 < byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        int n3 = 15;
        int n4 = 0;
        while (n4 < n) {
            char c = this.toOracleCharacterWithReplacement(cArray[n4]);
            int n5 = c & 0xFF00;
            if (n5 != 0) {
                if (n3 == 15) {
                    n3 = 14;
                    byArray[n2++] = 14;
                }
                byArray[n2++] = (byte)(n5 >> 8);
                byArray[n2++] = (byte)c;
            } else {
                if (n3 == 14) {
                    n3 = 15;
                    byArray[n2++] = 15;
                }
                byArray[n2++] = (byte)c;
            }
            ++n4;
        }
        if (n3 == 14) {
            n3 = 15;
            byArray[n2++] = 15;
        }
        if (n2 < byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = n + n2;
        char[] cArray = new char[n2];
        int n4 = n;
        int n5 = 0;
        int n6 = 15;
        while (n4 < n3) {
            int n7;
            if (byArray[n4] == 15) {
                n6 = 15;
                ++n4;
                continue;
            }
            if (byArray[n4] == 14) {
                n6 = 14;
                ++n4;
                continue;
            }
            if (n6 == 15) {
                n7 = byArray[n4] & 0xFF;
                cArray[n5++] = this.toUnicode(n7);
                ++n4;
                continue;
            }
            if (n4 < n3 - 1) {
                n7 = byArray[n4] << 8 & 0xFF00 | byArray[n4 + 1] & 0xFF;
                cArray[n5++] = this.toUnicode(n7);
                n4 += 2;
                continue;
            }
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        return new String(cArray, 0, n5);
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        char[] cArray = new char[n2];
        int n4 = n;
        int n5 = 0;
        int n6 = 15;
        while (n4 < n3) {
            int n7;
            if (byArray[n4] == 15) {
                n6 = 15;
                ++n4;
                continue;
            }
            if (byArray[n4] == 14) {
                n6 = 14;
                ++n4;
                continue;
            }
            if (n6 == 15) {
                n7 = byArray[n4] & 0xFF;
                cArray[n5++] = this.toUnicodeWithReplacement(n7);
                ++n4;
                continue;
            }
            if (n4 >= n3 - 1) break;
            n7 = byArray[n4] << 8 & 0xFF00 | byArray[n4 + 1] & 0xFF;
            cArray[n5++] = this.toUnicodeWithReplacement(n7);
            n4 += 2;
        }
        return new String(cArray, 0, n5);
    }
}

